/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	$Id: pgpRPCPwdCache.c,v 1.5.4.1 2001/04/19 18:33:38 ajivsov Exp $
____________________________________________________________________________*/
#include <windows.h>
#include "pgpPubTypes.h"
#include "pgpRPCMsg.h"
#include "pgpPassCach.h"
#include "pgpThreads.h"

#define CACHETIME	60000
#define TOKENTIME	 5000

extern PGPMutex_t sRpcMutex;
extern PGPContextRef gCtx;

void
pgpRPCThread(void *dummy)
{
	int count = 0;
	for(;;) {
		SleepEx(TOKENTIME, FALSE);

		pgpPollTokens( gCtx, &sRpcMutex );

		if( ++count >= (CACHETIME/TOKENTIME) )
		{
			pgpExpirePassphraseCache(gCtx);
			count = 0;
		}
	}
}
